<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class RefactoFieldCentersConcerned extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('node', 'events', 'centers_concerned');
        $bridge->contentTypeCreateOrUpdateField('events', 'centers', [
            'name' => 'centers',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
                'fr' => 'Centre concerné',
            ],
            'description' => [
                'fr' => 'Vous pouvez indiquer plusieurs centres',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 4,
                'hidden' => true,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['centers'],
                'cardinality' => -1,
            ],
        ]);
    }

    public function down(): void
    {
    }
}
