<?php

use Illuminate\Support\Str;
use Inside\Content\Models\Contents\Users;
use Inside\Database\Query\Builder;
use Inside\Host\Bridge\BridgeContent;

if (!function_exists('get_entity')) {
    function get_entity(array $record, BridgeContent $bridge, string $bundle, string $column): ?array
    {
        $name = trim(ucwords(strtolower($record[$column])));
        if (empty($name)) {
            return null;
        }

        $query = call_user_func('Inside\\Content\\Models\\Contents\\' . Str::studly($bundle) . '::query');
        if (Str::contains($name, ";")) {
            $dataUuid = [];
            $names = explode(";", $name);
            foreach ($names as $name) {
                $uuidReference = get_or_insert_reference($query, $name, $bundle, $bridge);
                $dataUuid = array_merge($dataUuid, $uuidReference ?? []);
            }
            return $dataUuid;
        }

        return get_or_insert_reference($query, $name, $bundle, $bridge);
    }
}

if (!function_exists('get_or_insert_reference')) {
    function get_or_insert_reference(Builder $query, string $name, string $bundle, BridgeContent $bridge): ?array
    {
        $entity = $query->where('title', $name)->first();

        if ($entity && isset($entity->uuid)) {
            return [$entity->uuid];
        }

        $uuidBridge = $bridge->contentInsert($bundle, [
            'title' => $name,
            'type' => 'node',
            'bundle' => $bundle,
        ]);

        if ($uuidBridge) {
            return [$uuidBridge];
        }

        return null;
    }
}

return [
    'files' => [
        'ssti' => [
            'path'      => __DIR__ . '/../../../../imports/import.csv',
            'separator' => ',',
            'fields'    => [
                'centers'    => function ($record, BridgeContent $bridge) {
                    return get_entity($record, $bridge, 'centers', 'centre 1');
                },
                'name'        => function ($record, BridgeContent $bridge) {
                    return trim($record['adresse e-mail']);
                },
                'mail'        => function ($record, BridgeContent $bridge) {
                    return trim($record['adresse e-mail']);
                },
                'firstname'   => function ($record, BridgeContent $bridge) {
                    return ucwords($record['prénom']);
                },
                'lastname'    => function ($record, BridgeContent $bridge) {
                    return ucwords($record['nom']);
                },
                'phone_centers'    => function ($record, BridgeContent $bridge) {
                    return ucwords($record['téléphone centre 1']);
                },
                'phone_centers_2'    => function ($record, BridgeContent $bridge) {
                    return ucwords($record['téléphone centre 2']);
                },
                'mobile'    => function ($record, BridgeContent $bridge) {
                    return ucwords($record['mobile']);
                },
                'function'    => function ($record, BridgeContent $bridge) {
                    return ucwords($record['fonction']);
                },
                'centers_2'    => function ($record, BridgeContent $bridge) {
                    return ucwords($record['centre 2']);
                },
                'post_number'    => function ($record, BridgeContent $bridge) {
                    return ucwords($record['numéro de poste']);
                },
                'jobs'    => function ($record, BridgeContent $bridge) {
                    return get_entity($record, $bridge, 'jobs', 'métier');
                },
                'referent'    => function ($record, BridgeContent $bridge) {
                    return get_entity($record, $bridge, 'referent', 'référent');
                },
                'services'    => function ($record, BridgeContent $bridge) {
                    return get_entity($record, $bridge, 'services', 'service');
                },
                'medical_teams'    => function ($record, BridgeContent $bridge) {
                    if (!isset($record['equipes médicales'])) {
                        return null;
                    }

                    if (Str::contains($record['equipes médicales'], ';')) {
                        $mails = explode(';', $record['equipes médicales']);
                        foreach ($mails as $mail) {
                            $insideUser = Users::query()->where('email', trim($mail))->first();
                            $uuidUser[] = $insideUser->uuid;
                            if (!$insideUser) {
                                return null;
                            }
                        }
                    }

                    return $uuidUser ?? null;
                },
                'status'      => function ($record, BridgeContent $bridge) {
                    return true;
                },
                'langcode'  => function ($record, BridgeContent $bridge) {
                    return 'fr';
                },
            ]
        ]
    ],
];
