import Microsoft from '@inside-auth/components/login/extra-component/Microsoft'
import UserCard from './components/users/UserCard'

const origin = new URL(
  process.env.NODE_ENV === 'development'
    ? JSON.parse(process.env.GLOBAL).localURL
    : window.location
).origin

export default {
  globals: {
    calendarExportTypes: [
      {
        type: 'ics',
        label: 'iCalendar'
      }
    ]
  },
  'inside-archives': {
    isEnabled: true
  },
  'inside-auth': {
    extraComponent: {
      is: Microsoft,
      link: `${origin}/oauth2/login`
    }
  },
  'inside-edition': {
    revisionEnabled: true,
    duplicateEnabled: true
  },
  'inside-events': {
    subscriptionEnabled: true,
    calendarImportEnabled: true,
    showBookmarks: true,
    bookmarkEnabled: true
  },
  'inside-layouts': {
    tabsPagesBookmarkEnabled: true,
    pagesBookmarkEnabled: true
  },
  'inside-newcomers': {
    extraFields: [
      {
        field: 'functions',
        class: 'function',
        data: data => data?.functions?.data.map(f => f.title)?.join(', ')
      }
    ]
  },
  'inside-news': {
    minimalDate: true,
    bookmarkEnabled: true,
    showBookmarks: true
  },
  'inside-organizational-chart': {
    functionKey: 'functions'
  },
  'inside-users': {
    csvImport: true,
    shortcuts: {
      max: 6
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'notifications', restrictions: [], icon: 'settings' },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' }
      ]
    },
    paragraphs: {
      fetchedContents: {
        display: () => import('./components/users/UserCard'),
        requestFields: [
          'uuid',
          'firstname',
          'lastname',
          'phone',
          'image',
          { functions: ['title', 'uuid'] }
        ]
      }
    }
  }
}
