<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;

class Sid2TranslateUsersFields extends Migration
{
    public function up(): void
    {
        $dictionary = [
            'birthday' => [
                'fr' => 'Anniversaire',
                'en' => 'Birthday',
                'es' => 'Cumpleaños',
                'de' => 'Geburtstag',
                'pt' => 'Aniversário',
                'nl' => 'Verjaardag',
            ],
            'image' => [
                'fr' => 'Photo de profil',
                'en' => 'Profile picture',
                'es' => 'Foto de perfil',
                'de' => 'Profilbild',
                'pt' => 'Foto de perfil',
                'nl' => 'Profielfoto',
            ],
            'firstname' => [
                'fr' => 'Prénom',
                'en' => 'First name',
                'es' => 'Nombre',
                'de' => 'Vorname',
                'pt' => 'Primeiro nome',
                'nl' => 'Voornaam',
            ],
            'lastname' => [
                'fr' => 'Nom',
                'en' => 'Last name',
                'es' => 'Apellido',
                'de' => 'Nachname',
                'pt' => 'Nome',
                'nl' => 'Naam',
            ],
            'function' => [
                'fr' => 'Fonction',
                'en' => 'Function',
                'es' => 'Función',
                'de' => 'Funktion',
                'pt' => 'Função',
                'nl' => 'Functie',
            ],
            'phone' => [
                'fr' => 'Téléphone',
                'en' => 'Phone',
                'es' => 'Teléfono',
                'de' => 'Telefon',
                'pt' => 'Telefone',
                'nl' => 'Telefoon',
            ],
            'tools' => [
                'fr' => 'Accès rapides',
                'en' => 'Quick access',
                'es' => 'Acceso rapido',
                'de' => 'Schneller Zugang',
                'pt' => 'Acesso rápido',
                'nl' => 'Snelle toegang',
            ],
            'is_maintenance' => [
                'fr' => 'Compte de maintenance ?',
                'en' => 'Maintenance account?',
                'es' => 'cuenta de mantenimiento?',
                'de' => 'Wartungskonto?',
                'pt' => 'Conta de manutenção?',
                'nl' => 'Onderhoudsrekening?',
            ],
            'send_mail' => [
                'fr' => 'Envoyer un mail à la création de mot de passe',
                'en' => 'Send email to password creation',
                'es' => 'Enviar correo electrónico a la creación de contraseña',
                'de' => 'E-Mail zur Passworterstellung senden',
                'pt' => 'Enviar um e-mail para criar uma palavra-passe',
                'nl' => 'Stuur een e-mail bij het aanmaken van een wachtwoord',
            ],
            'is_gdpr_compliant' => [
                'fr' => 'RGPD Compliant',
                'en' => 'RGPD Compliant',
                'es' => 'RGPD Compliant',
                'de' => 'RGPD Compliant',
                'pt' => 'RGPD Compliant',
                'nl' => 'AVG-compatibel',
            ],
        ];
        $bridge = new BridgeContentType();
        collect(Schema::getFieldListing('users'))
            ->diff(['status', 'author','body'])
            ->each(function (string $field) use ($dictionary, $bridge) {
                $options = Schema::getFieldOptions('users', $field);
                $titles = $dictionary[$field] ?? [];

                if (!empty($titles) && $this->shouldUpdateTitles($titles, $options)) {
                    $bridge->changeFieldTitle('users', $field, $titles);
                }
            });
    }

    private function shouldUpdateTitles(array $titles, array $fieldOptions): bool
    {
        return collect($titles)->some(fn ($title, $langcode) => $title !== ($fieldOptions['title'][$langcode] ?? null));
    }
}
