<?php

return [
    '_meta' => [
        'type' => 'newsletters',
        'name' => 'Newsletter',
    ],
    'logo' => [
        'showLogo' => true,
        'logoWidth' => 80,
    ],
    'banner' => [
        'backgroundColor' => '#ffff',
        'height',
    ],
    'introduction' => [
        'introductionFieldName' => 'introduction',
    ],
    'sections' => [
        'news'       => [
            'sectionTitleStrKey' => 'newsletter.news_title',
            'types' => ['news'],
            'dateFormat' => '%d/%m/%Y',
            'showCategoryTitle' => true,
            'showIntroduction' => true,
            'defaultCategoryColor' => '#B32027',
            'link' => [
                'sectionLinkUrl'  => 'actualites',
                'sectionTextColor' => '#203169',
            ],
        ],
        'events'     => [
            'sectionTitleStrKey' => 'newsletter.events_title',
            'types' => ['events'],
            'sorts' => ['date:desc'],
            'dateFormat' => '%d/%m/%Y',
            'categoryFieldName' => 'events_categories',
            'defaultCategoryColor' => '#B32027',
            'link' => [
                'sectionLinkUrl'   => 'events',
                'sectionTextColor' => '#203169',
            ],
        ],
        'documents'  => [
            'sectionTitleStrKey' => 'newsletter.documents_title',
            'types'           => ['documents'],
            'sorts' => ['created_at:desc'],
            'imageStyle' => 'medium',
            'dateFormat' => '%d/%m/%Y',
            'link'            => [
                'sectionLinkStrKey' => 'newsletter.see_all_documents',
                'sectionLinkUrl' => 'bibliotheque',
                'sectionTextColor' => '#203169'
            ],
        ],
    ],
    'socials'      => [
        'backgroundColor' => '#203169',
        'links' => [
            'facebook' => [
                'url' => 'https://www.facebook.com/vadoncchezSpeedy',
            ],
            'linkedin' => [
                'url' => 'https://fr.linkedin.com/company/speedy-france',
            ],
            'youtube' => [
                'url' => 'https://www.youtube.com/@SpeedyFranceOfficiel/videos',
            ],
            'tiktok' => [
                'url' => 'https://www.tiktok.com/@speedyfrance?_t=ZN-90mjzHF8tSF&_r=1',
            ]
        ],
    ],
];
