<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;

class SpeeHidePages extends Migration
{
    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();
        collect([
            'public_pages', 'custom'
        ])->each(fn ($type) => $bridgeContentType->updateContentTypeOptions(
            type: $type,
            options: [
                'listing_type' => 'hidden',
            ]
        ));
        Artisan::call("models:rebuild");
    }
}
