<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class SpeeHideLanguageFields extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        foreach (Schema::getContentTypes() as $type) {
            $options = Schema::getModelOptions($type);

            if (Schema::hasField($type, 'langcode')) {
                $langcodeFieldOptions = Schema::getFieldOptions($type, 'langcode');

                if ($langcodeFieldOptions['displayed']) {
                    $bridge->changeFieldFormOptions($type, 'langcode', false, 'group_advanced_options');
                }
            }
        }
    }
}
