<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class TranslateContentTypes extends Migration
{
    public function up(): void
    {
        $types = [
            "connexion_popups",
            "dms_link",
            "movements",
            "movements_categories",
            "pages",
            "public_pages",
            "top_footer",
        ];

        $bridgeContentType = new BridgeContentType();
        foreach ($types as $type) {
            $bridgeContentType->contentTypeUpdateOrCreate($type, [
                'name' => $type,
                'translatable' => true
            ]);
        }
    }
}
