<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'news_categories',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => true,
        'listing_type' => 'taxo',
        'title' => [
            'fr' => 'Catégorie d\'actualité',
            'en' => 'News Category',
            'nl' => 'Nieuwscategorie',
            'pt' => 'Categoria de notícias',
            'es' => 'Categoría de noticias',
            'de' => 'Nachrichten-Kategorie',
        ],
    ],
    'fields' => [
        [
            'name' => 'color',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Couleur',
                'en' => 'Color',
                'nl' => 'Kleur',
                'pt' => 'Cor',
                'es' => 'Color',
                'de' => 'Farbe',
            ],
            'description' => [
                'fr' => 'Cette couleur sera appliquée sur le nom de la catégorie sur les actualités',
                'en' => 'This color will be applied to the category name on news',
                'nl' => 'Deze kleur wordt toegepast op de categorienaam op nieuws',
                'pt' => 'Esta cor será aplicada ao nome da categoria nas notícias',
                'es' => 'Este color se aplicará al nombre de la categoría en las noticias.',
                'de' => 'Diese Farbe wird auf den Kategorienamen in Nachrichten angewendet',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
    ],
];
