<?php

use Inside\Content\Models\Contents\Department;
use Inside\Host\Bridge\BridgeContent;
use Inside\Content\Models\Contents\Users;

return [
    'sync_attributes' => [
        'firstname' => 'givenName',
        'lastname' => 'surname',
        'mail' => 'mail',
        'name' => 'mail',
        'status' => fn () => 1,
        'is_maintenance' => fn () => false,
        'phone' => fn (mixed $user) => $user->businessPhones[0] ?? "",
        'mobile_phone' => 'mobilePhone',
        'functions' => fn (mixed $user) => reference('functions')->identifiedBy('code')->from($user->jobTitle)->get(),
        'services' => fn (mixed $user) => reference('services')->identifiedBy('code')->from($user->department)->get(),
        'manager' => fn (mixed $user) => reference('users')->identifiedBy('email')->from($user->manager)->withoutCreation()->get(),
    ],
    'custom_attributes' => [
        'manager' => 'mail'
    ]
];
