import SpacePage from '../pages/spaces/SpacePage'
import TabSpacePage from '../pages/spaces/TabSpacePage'
import TabPage from '../pages/tabs/TabPage'

import { fetchSpace, fetchSpacesTabs } from '../components/spaces/fetch'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false },
    props: {
      filtersInput: 'selectbox'
    }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'EventSubscriptionPage',
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      gridMinMax: '250',
      cardSize: 's',
      cardOverlayEnabled: false,
      extraFilters: {
        sort: ['weight:asc', 'title:asc']
      }
    }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/users/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'MapPage',
    component: () => import('../pages/MapPage'),
    meta: { disabled: false }
  },
  {
    name: 'FAQListingPage',
    meta: { disabled: false }
  },
  {
    name: 'SpacesListingPage',
    component: () => import('../pages/spaces/SpacesListingPage'),
    path: {
      fr: '/espaces',
      en: '/spaces'
    }
  },
  {
    name: 'SpacePage',
    component: withFetch(SpacePage, { size: 'xxl', watch: true })(fetchSpace),
    path: {
      fr: '/espaces/:slug',
      en: '/spaces/:slug'
    },
    meta: { content: 'spaces' }
  },
  {
    name: 'TabSpacePage',
    component: withFetch(TabSpacePage, { size: 'xxl', watch: true })(
      fetchSpace
    ),
    path: {
      fr: '/espaces/pages/:slug',
      en: '/spaces/pages/:slug'
    },
    alias: ['/fr/espaces/:slug/pages', '/en/spaces/:slug/pages'],
    meta: { content: 'spaces' }
  },
  {
    name: 'TabPage',
    component: withFetch(TabPage, { size: 'xxl', watch: true })(
      fetchSpacesTabs
    ),
    path: {
      fr: '/espaces-onglet/pages/:slug',
      en: '/spaces-tab/pages/:slug'
    },
    alias: ['/fr/espaces-onglet/:slug/pages', '/en/spaces-tab/:slug/pages'],
    meta: { content: 'spaces_tabs' }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false, content: 'pages' }
  },
  {
    name: 'AdminAdvancedSettingsAutomaticTranslationPage',
    meta: { admin: true, display: true }
  }
]
