import { http } from '@inside-library/helpers/Http'

export default {
  spaces: {
    add: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({
      name: 'SpacesListingPage'
    })
  },
  pagesCategories: {
    add: async ({ data }) => {
      const { data: pagesCategories } = await http.get(
        'content/pages_categories',
        {
          fields: [
            'uuid',
            'slug',
            {
              spaces: {
                fields: ['uuid', 'title', 'slug']
              }
            }
          ],
          filters: {
            'status:eq': 1,
            'uuid:eq': data.uuid
          }
        }
      )

      return {
        name: 'TabSpacePage',
        params: {
          slug: pagesCategories[0].spaces.slug[0]
        }
      }
    },
    delete: async ({ uuid }) => {
      const { data: pagesCategories } = await http.get(
        'content/pages_categories',
        {
          fields: [
            'uuid',
            {
              spaces: {
                fields: ['uuid', 'title', 'slug']
              }
            }
          ],
          filters: {
            'status:eq': 1,
            'uuid:eq': uuid
          }
        }
      )

      return {
        name: 'TabSpacePage',
        params: {
          slug: pagesCategories[0].spaces.slug[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: pagesCategories } = await http.get(
        'content/pages_categories',
        {
          fields: ['uuid', { spaces: ['uuid', 'title', 'slug'] }],
          filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
        }
      )

      return {
        route: {
          name: 'TabSpacePage',
          params: {
            slug: pagesCategories[0].spaces.slug[0]
          }
        }
      }
    }
  },
  spacesPages: {
    add: async ({ data }) => {
      const { data: spacesPages } = await http.get('content/spaces_pages', {
        fields: [
          'uuid',
          'slug',
          {
            pages_categories: [
              'uuid',
              'title',
              {
                spaces: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: {
          'status:eq': 1,
          'uuid:eq': data.uuid
        }
      })

      return {
        name: 'TabSpacePage',
        params: {
          slug: spacesPages[0].pages_categories.spaces.slug[0]
        },
        query: { page: data.uuid }
      }
    },
    delete: async ({ uuid }) => {
      const { data: spacesPages } = await http.get('content/spaces_pages', {
        fields: [
          'uuid',
          'title',
          {
            pages_categories: [
              'uuid',
              'title',
              {
                spaces: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: {
          'status:eq': 1,
          'uuid:eq': uuid
        }
      })

      return {
        name: 'TabSpacePage',
        params: {
          slug: spacesPages[0].pages_categories.spaces.slug[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: spacesPages } = await http.get('content/spaces_pages', {
        fields: [
          'uuid',
          'title',
          {
            pages_categories: [
              'uuid',
              'title',
              {
                spaces: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: { 'uuid:eq': data.uuid }
      })


      return {
        route: {
          name: 'TabSpacePage',
          params: {
            slug: spacesPages[0].pages_categories.spaces.slug[0]
          },
          query: { page: data.uuid }
        }
      }
    }
  },
  spacesTabs: {
    add: ({ data }) => ({
      name: 'TabPage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({
      name: 'SpacesListingPage'
    })
  },
  tabsCategories: {
    add: async ({ data }) => {
      const { data: pagesCategories } = await http.get(
        'content/tabs_categories',
        {
          fields: [
            'uuid',
            'slug',
            {
              spaces_tabs: {
                fields: ['uuid', 'title', 'slug']
              }
            }
          ],
          filters: {
            'status:eq': 1,
            'uuid:eq': data.uuid
          }
        }
      )

      return {
        name: 'TabPage',
        params: {
          slug: pagesCategories[0].spaces_tabs.slug[0]
        }
      }
    },
    delete: async ({ uuid }) => {
      const { data: pagesCategories } = await http.get(
        'content/tabs_categories',
        {
          fields: [
            'uuid',
            {
              spaces_tabs: {
                fields: ['uuid', 'title', 'slug']
              }
            }
          ],
          filters: {
            'status:eq': 1,
            'uuid:eq': uuid
          }
        }
      )

      return {
        name: 'TabPage',
        params: {
          slug: pagesCategories[0].spaces_tabs.slug[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: pagesCategories } = await http.get(
        'content/tabs_categories',
        {
          fields: ['uuid', { spaces_tabs: ['uuid', 'title', 'slug'] }],
          filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
        }
      )

      return {
        route: {
          name: 'TabPage',
          params: {
            slug: pagesCategories[0].spaces_tabs.slug[0]
          }
        }
      }
    }
  },
  tabsPages: {
    add: async ({ data }) => {
      const { data: spacesPages } = await http.get('content/tabs_pages', {
        fields: [
          'uuid',
          'slug',
          {
            tabs_categories: [
              'uuid',
              'title',
              {
                spaces_tabs: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: {
          'status:eq': 1,
          'uuid:eq': data.uuid
        }
      })

      return {
        name: 'TabPage',
        params: {
          slug: spacesPages[0].tabs_categories.spaces_tabs.slug[0]
        },
        query: { page: data.uuid }
      }
    },
    delete: async ({ uuid }) => {
      const { data: spacesPages } = await http.get('content/tabs_pages', {
        fields: [
          'uuid',
          'title',
          {
            tabs_categories: [
              'uuid',
              'title',
              {
                spaces_tabs: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: {
          'status:eq': 1,
          'uuid:eq': uuid
        }
      })

      return {
        name: 'TabPage',
        params: {
          slug: spacesPages[0].tabs_categories.spaces_tabs.slug[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: spacesPages } = await http.get('content/tabs_pages', {
        fields: [
          'uuid',
          'title',
          {
            tabs_categories: [
              'uuid',
              'title',
              {
                spaces_tabs: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: { 'uuid:eq': data.uuid }
      })

      return {
        route: {
          name: 'TabPage',
          params: {
            slug: spacesPages[0].tabs_categories.spaces_tabs.slug[0]
          },
          query: { page: data.uuid }
        }
      }
    }
  }
}
