<?php

declare(strict_types=1);

use Inside\Host\Bridge\BridgeContent;

return [
    'files' => [
        'soge' => [
            'path' => env('CSV_USERS_PATH', __DIR__.'/../../../../imports/users.csv'),
            'separator' => env('CSV_USERS_SEPARATOR', ','),
            'fields' => [
                'email' => fn (array $record) => trim($record['mail']),
                'name' => fn (array $record) => trim($record['mail']),
                'firstname' => fn (array $record) => ucwords(trim($record['first_name'])),
                'lastname' => fn (array $record) => ucwords(trim($record['last_name'])),
                'function' => fn (array $record) => trim($record['job_title']) ?: null,
                'phone' => fn (array $record) => trim($record['phone']) ?: null,
                'mobile_phone' => fn (array $record) => trim($record['mobile']) ?: null,
                'locations' => fn (array $record) => reference('locations')->from(
                    trim($record['location']) ?: null
                )->get(),
                'status' => fn () => 1,
            ],
        ],
    ],
];
