import RhSpace from '../pages/spaces/RhSpace'
import RhSpacesPage from '../pages/spaces/RhSpacesPage'
import CseSpace from '../pages/spaces/CseSpace'
import {
  fetchRhSpacesPage,
  fetchCseSpace,
  fetchRhSpace
} from '../components/spaces/fetch'

import OrganizationalChartPage from '../pages/charts/OrganizationalChartPage'
import { fetchOrganizationalChartPage } from '../components/charts/fetch'

import AdminAdvancedSettingsHomePage from '../pages/advanced-settings/AdminAdvancedSettingsHomePage'
import AdminAdvancedSettingsIdentityPage from '../pages/advanced-settings/AdminAdvancedSettingsIdentityPage'
import { fetchSettings } from '@inside-administration/fetch'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      extraFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'EventSubscriptionPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsTikehauListingPage',
    path: '/actualites-tikehau',
    component: () => import('../pages/news-tikehau/NewsTikehauListingPage')
  },
  {
    name: 'NewsTikehauPage',
    path: '/actualites-tikehau/:slug',
    component: () => import('../pages/news-tikehau/NewsTikehauPage')
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: { homeWithCards: false }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/directory/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'RhSpace',
    path: '/espace-rh/:slug',
    component: withFetch(RhSpace, { size: 'xxl' })(fetchRhSpace)
  },
  {
    name: 'RhSpacesPage',
    path: '/espace-rh/:slug/:page',
    component: withFetch(RhSpacesPage, { size: 'xxl' })(fetchRhSpacesPage),
    meta: { content: 'rh_spaces' }
  },
  {
    name: 'CseSpace',
    path: '/espace-cse',
    component: withFetch(CseSpace, { size: 'xxl' })(fetchCseSpace)
  },
  {
    name: 'OrganizationalChartListingPage',
    path: '/organigrammes',
    component: () => import('../pages/charts/OrganizationalChartListingPage')
  },
  {
    name: 'OrganizationalChartPage',
    path: '/organigrammes/:slug',
    component: withFetch(OrganizationalChartPage, { size: 'xxl' })(
      fetchOrganizationalChartPage
    )
  },
  {
    name: 'JobsListingPage',
    path: '/offres-d-emploi',
    component: () => import('../pages/jobs/JobsListingPage')
  },
  {
    name: 'AdminAdvancedSettingsHomePage',
    component: withFetch(AdminAdvancedSettingsHomePage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  },
  {
    name: 'AdminAdvancedSettingsIdentityPage',
    component: withFetch(AdminAdvancedSettingsIdentityPage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  },
  {
    name: 'AdminAdvancedSettingsWeatherPage',
    meta: { admin: true, display: true }
  }
]
