import { http } from '@inside-library/helpers/Http'

export default {
  newsTikehau: {
    add: ({ data }) => ({
      name: 'NewsTikehauPage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({ name: 'NewsTikehauListingPage' })
  },
  cseSpaces: {
    add: () => ({
      name: 'CseSpace'
    })
  },
  cseFolders: {
    add: ({ data }) => ({
      name: 'CseSpace',
      query: { folder: data.uuid }
    }),
    delete: () => ({
      name: 'CseSpace'
    })
  },
  cseDocuments: {
    fields: [{ cse_folders: ['uuid'] }],
    add: ({ data }) => ({
      name: 'CseSpace',
      query: { folder: data.cse_folders && data.cse_folders.uuid }
    }),
    delete: ({ data }) => ({
      name: 'CseSpace',
      query: { folder: data.cse_folders && data.cse_folders.uuid }
    })
  },
  groupsDocuments: {
    fields: [{ groups: ['slug'] }, { groups_folders: ['uuid'] }],
    add: ({ data }) => ({
      path: `/groupes-collaboratifs/${data.groups.data[0].slug[0]}/documents`,
      query: {
        folder: data.groups_folders.data[0] && data.groups_folders.data[0].uuid
      }
    }),
    delete: ({ data }) => ({
      path: `/groupes-collaboratifs/${data.groups.data[0].slug[0]}/documents`,
      query: {
        folder: data.groups_folders.data[0] && data.groups_folders.data[0].uuid
      }
    })
  },
  groupsFolders: {
    extends: 'groupsDocuments'
  },
  rhSpaces: {
    add: ({ data }) => ({
      name: 'RhSpace',
      params: { slug: data.slug[0] }
    })
  },
  rhPages: {
    fields: [{ spaces_categories: { spaces: ['slug'] } }],
    add: ({ data }) => ({
      name: 'RhSpace',
      params: { slug: data.spaces_categories.data?.[0]?.spaces?.slug?.[0] }
    }),
    delete: () => ({ name: 'RhSpace' }),
    globalSearch: async ({ data }) => {
      const { data: rhCategories } = await http.get('content/rh_pages', {
        fields: ['uuid', { spaces_categories: ['uuid', 'title'] }],
        filters: { 'uuid:eq': data.uuid }
      })

      const { data: rhSpace } = await http.get('content/rh_categories', {
        fields: ['uuid', { spaces: ['uuid', 'title', 'slug'] }],
        filters: {
          'uuid:eq': rhCategories?.[0]?.spaces_categories.data?.[0]?.uuid
        }
      })

      return {
        route: {
          name: 'RhSpace',
          params: {
            slug: rhSpace?.[0]?.spaces?.slug?.[0]
          }
        }
      }
    }
  },
  rhCategories: {
    fields: [{ spaces: ['slug'] }],
    add: ({ data }) => ({
      name: 'RhSpace',
      params: { slug: data.spaces?.slug?.[0] }
    }),
    delete: ({ data }) => ({
      name: 'RhSpace',
      params: { slug: data.spaces?.slug?.[0] }
    }),
    globalSearch: async ({ data }) => {
      const { data: rhCategories } = await http.get('content/rh_categories', {
        fields: ['uuid', { spaces: ['slug'] }],
        filters: { 'uuid:eq': data.uuid }
      })

      return {
        route: {
          name: 'RhSpace',
          params: {
            slug: rhCategories?.[0]?.spaces?.slug?.[0]
          }
        }
      }
    }
  },
  organizationalCategories: {
    add: () => ({ name: 'OrganizationalChartListingPage' }),
    delete: () => ({ name: 'OrganizationalChartListingPage' })
  },
  organizationalChart: {
    add: ({ data }) => ({
      name: 'OrganizationalChartPage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({
      name: 'OrganizationalChartListingPage'
    })
  },
  jobs: {
    add: () => ({ name: 'JobsListingPage' }),
    delete: () => ({ name: 'JobsListingPage' })
  }
}
