import { http } from '@inside-library/helpers/Http'
import { upcomingEventsDateFilters } from '@inside-events/constants'

export const fetchRhSpacesPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/rh_pages', {
      fields: [
        'uuid',
        'title',
        'content',
        'admin',
        'content_type',
        {
          spaces_categories: {
            fields: ['uuid', 'title'],
            filters: {
              'status:eq': 1
            }
          }
        }
      ],
      filters: { 'slug:eq': $route.params.page }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchCseSpace = async ({ $route }) => {
  try {
    const { data } = await http.get('content/cse_spaces', {
      fields: [
        'uuid',
        'admin',
        'content_type',
        'title',
        'banner',
        'introduction',
        'image',
        'presentations',
        {
          events: [
            { events_categories: { fields: ['color', 'title'] } },
            'date',
            'end_date',
            'image',
            'place',
            'title',
            'content_type',
            'slug',
            'uuid'
          ],
          filters: {
            ...upcomingEventsDateFilters,
            'status:eq': 1,
            sort: 'date:asc',
            limit: 2
          }
        },
        {
          referents: [
            'uuid',
            'lastname',
            'firstname',
            'image',
            'phone',
            'function'
          ],
          filters: {
            'status:eq': 1,
            limit: 2
          }
        }
      ],
      filters: { 'slug:eq': $route.params.slug, limit: 1 }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchRhSpace = async ({ $route }) => {
  try {
    const { data } = await http.get('content/rh_spaces', {
      fields: [
        'uuid',
        'admin',
        'content_type',
        'title',
        'banner',
        'introduction',
        'cta_image',
        'cta_link',
        'cta_sub_title',
        'cta_title',
        {
          referents: {
            fields: [
              'uuid',
              'firstname',
              'lastname',
              'image',
              'function',
              'phone'
            ],
            filters: {
              'status:eq': 1,
              sort: 'lastname:asc'
            }
          }
        },
        {
          space_links: {
            fields: [
              'uuid',
              'content_type',
              'admin',
              'title',
              'space_link',
              'image',
              'icon',
              'open_in_new_tab'
            ],
            filters: {
              'status:eq': 1,
              'published_at:lte': 'now()'
            }
          }
        },
        {
          news: {
            fields: [
              'uuid',
              'title',
              'image',
              'published_at',
              'chapo',
              'slug',
              'content_type',
              { reactions: ['count', { users: ['uuid'] }] },
              { comments: ['count'] },
              {
                news_categories: {
                  fields: ['uuid', 'title'],
                  filters: { 'status:eq': 1 }
                }
              }
            ],
            filters: {
              'status:eq': 1,
              sort: 'published_at:desc',
              limit: 2
            }
          }
        },
        'show_call_to_action',
        'show_job_offers'
      ],
      filters: { 'slug:eq': $route.params.slug, limit: 1 }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
