import { onMounted } from 'vue'
import { getAppInstance } from '@inside-core/helpers/getAppInstance'

import JobsModal from '../components/jobs/JobsModal'
import RhPagesModal from '../components/spaces/modal/RhPagesModal'


export function useGlobalComponents() {
  const app = getAppInstance()

  onMounted(() => {
    app.component('jobs-modal', JobsModal)
    app.component('rh-pages-modal', RhPagesModal)
  })
}
