import { http } from '@inside-library/helpers/Http'

export const fetchSocialBlock = async () => {
  try {
    const { data } = await http.get('content/social_cards_links', {
      fields: [
        'uuid',
        'title',
        'image',
        'link',
        'published_at',
        'content_type',
        'admin'
      ],
      filters: { 'status:eq': 1, sort: 'published_at:desc', limit: 1 }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
