import { http } from '@inside-library/helpers/Http'

export const fetchOrganizationalChartPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/organizational_chart', {
      fields: [
        'uuid',
        'title',
        'descriptions',
        'content',
        'admin',
        'banner',
        'content_type',
        'image'
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
