export default {
  documents: {
    modalFields: [
      { authors: ['lastname', 'firstname'] },
      'content',
      'body',
      'content_type',
      'published_at',
      'file',
      'langcode',
      'pid',
      'status',
      'title',
      'updated_at',
      'uuid',
      'uuid_host',
      { reactions: ['count', { users: ['uuid'] }] },
      { folders: ['title'] }
    ]
  },
  cse_documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'updated_at',
      'file',
      { cse_folders: ['title'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  },
  groups_documents: {
    modalFields: [
      { authors: ['lastname', 'firstname'] },
      'content',
      'body',
      'content_type',
      'published_at',
      'updated_at',
      'file',
      'langcode',
      'pid',
      'status',
      'title',
      'uuid',
      'uuid_host',
      { reactions: ['count', { users: ['uuid'] }] },
      { groups_folders: ['title'] }
    ]
  },
  users: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'firstname',
      'lastname',
      'email',
      'phone',
      'mobile',
      'image',
      'function',
      'services',
      'manager',
      'locations',
      'dwelling_place',
      'direct_line',
      { entities: ['title'] }
    ]
  },
  rh_pages: {
    modalFields: [
      'title',
      'uuid',
      'slug',
      'admin',
      'content_type',
      'content',
      { spaces_categories: ['title', 'uuid'] }
    ]
  },
  jobs: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'content',
      'start_date',
      'content_type',
      'email',
      'salary',
      { main_location: ['title'] },
      { locations: ['title'] },
      { services: ['title'] },
      { contracts: ['title'] }
    ]
  },
  // GDPR modal content type
  modal: {
    modalFields: ['class', 'content']
  }
}
