<?php

namespace Inside\SOFI\Services;

use GuzzleHttp\Client;
use Illuminate\Support\Facades\Date;

class AlphavantageService
{
    private ?Client $client = null;

    private function getClient(): Client
    {
        return $this->client ??= new Client(['base_uri' => config('alphavantage.api_uri')]);
    }

    public function getGlobalQuote(string $symbol): ?array
    {
        $response = $this->getClient()->get('', [
            'query' => [
                'function' => 'GLOBAL_QUOTE',
                'symbol' => $symbol,
                'apikey' => config('alphavantage.api_key')
            ],
        ]);

        $data = json_decode($response->getBody()->getContents(), true);

        if (empty($data['Global Quote'])) {
            return null;
        }

        return [
            'symbol' => $data['Global Quote']['01. symbol'],
            'open' => floatval($data['Global Quote']['02. open']),
            'high' => floatval($data['Global Quote']['03. high']),
            'low' => floatval($data['Global Quote']['04. low']),
            'price' => floatval($data['Global Quote']['05. price']),
            'volume' => floatval($data['Global Quote']['06. volume']),
            'latest trading day' => $data['Global Quote']['07. latest trading day'],
            'previous close' => floatval($data['Global Quote']['08. previous close']),
            'change' => floatval($data['Global Quote']['09. change']),
            'change percent' => floatval($data['Global Quote']['10. change percent']),
        ];
    }
}
