<?php

namespace Inside\SOFI\Providers;

use Illuminate\Support\Facades\Event;
use Inside\Content\Events\ContentFullyInsertedEvent;
use Inside\Support\EventServiceProvider as BaseServiceProvider;
use Inside\SOFI\Console\ExportJobsContentsCommand;
use Inside\SOFI\Console\ImportEventsTikehau;
use Inside\SOFI\Console\ImportStockExchange;
use Inside\SOFI\Console\CleanReferencesCommand;
use Inside\SOFI\Console\ImportNewsTikehau;
use Inside\SOFI\Http\Middleware\WeatherData;
use Inside\SOFI\Listeners\ContentCreatedListener;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

/**
 * SOFI Service provider.
 *
 * @category Class
 * @package  Inside\SOFI\Providers\ServiceProvider
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ServiceProvider extends BaseServiceProvider
{
    protected array $listen = [
        ContentFullyInsertedEvent::class => [
            ContentCreatedListener::class,
        ],
    ];

    protected array $commands = [
        ImportStockExchange::class,
        CleanReferencesCommand::class,
        ImportNewsTikehau::class,
        ImportEventsTikehau::class,
        ExportJobsContentsCommand::class,
    ];

    public function register(): void
    {
        $this->app->middleware([
            WeatherData::class,
        ]);
        try {
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/permission.php', 'permission');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
            $this->mergeConfigTo(__DIR__.'/../../config/notify.php', 'notify');
            $this->mergeConfigTo(__DIR__ . '/../../config/ldap_auth.php', 'ldap_auth');
            $this->mergeConfigTo(__DIR__ . '/../../config/tikehau.php', 'tikehau');
            $this->mergeConfigTo(__DIR__.'/../../config/external_api.php', 'external_api');
            $this->mergeConfigTo(__DIR__.'/../../config/alphavantage.php', 'alphavantage');
            $this->mergeConfigTo(__DIR__.'/../../config/user_references.php', 'user_references');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }
    }
}
