<?php

namespace Inside\SOFI\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Content\Events\ContentFullyInsertedEvent;
use Inside\Content\Models\Contents\Tools;
use Inside\Content\Models\Contents\Users;
use Inside\Content\Models\Field;
use Inside\Host\Bridge\BridgeContent;
use Inside\Notify\Listeners\BaseNotificationListener;

/**
 * Handle default shortcuts for new users
 *
 * @category Class
 * @package  Inside\User\Listeners\ContentCreatedListener
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ContentCreatedListener extends BaseNotificationListener implements ShouldQueue
{
    public function handle(ContentFullyInsertedEvent $event): void
    {
        $model = $event->model;
        if (get_class($model) !== Users::class) {
            return;
        }

        // Check if the shortcuts_menus field exists on users
        $field = Field::whereHas(
            'model',
            function ($query) {
                $query->whereClass('Inside\Content\Models\Contents\Users');
            }
        )->where('name', 'tools')->first();

        if (!$field) {
            return;
        }

        // The user already has shortcuts menus
        if ($model->tools->count() > 0) {
            return;
        }

        // Get default shortcuts
        $defaultShortcuts = [];

        $options = $field->options ?? [];
        foreach ($options['default'] as $uuid_host) {
            $shortcut =
                Tools::where('uuid_host', $uuid_host)->first();

            if (!$shortcut) {
                continue;
            }
            $defaultShortcuts[] = $shortcut->uuid;
        }

        if (empty($defaultShortcuts)) {
            return;
        }

        $bridge = new BridgeContent();

        $bridge->contentUpdate(
            'users',
            [
                'uuid' => $model->uuid,
                'tools' => $defaultShortcuts,
            ]
        );
    }
}
