<?php

namespace Inside\SOFI\Http\Controllers;

use Inside\Content\Contracts\Transformer;
use Inside\Content\Models\Contents\Contracts;
use Illuminate\Http\Request;
use Inside\Content\Models\Contents\Jobs;
use Inside\Content\Models\Contents\Locations;
use Inside\Content\Models\Contents\Services;
use Inside\Permission\Facades\Permission;
use Inside\SOFI\Facades\JobOffers;
use Laravel\Lumen\Routing\Controller;
use Symfony\Component\HttpFoundation\JsonResponse;

/**
 * @class JobOffersController
 *
 * @category Class
 * @package  Inside\Content\Http\Controllers
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class JobOffersController extends Controller
{
    protected array $attributes = [
        'title', 'email', 'created_at', 'content', 'main_location' => ['title'],
        'locations' => ['title'], 'services' => ['title'], 'contracts' => ['title']
    ];

    public function getJob(Transformer $transformer, string $uuid): JsonResponse
    {
        Permission::disableAllowedScope();

        $job = Jobs::where('status', 1)->where('uuid', $uuid)->where('share_sofidy', 1)->first();
        $data = $transformer->transform($job, $this->attributes);

        $result = JobOffers::removeUselessContents($data);

        $date = date("d F Y", $result['created_at']);
        $result['created_at'] = $date;

        return response()->json($result, 200, ['Content-Type', 'application/json'], true);
    }

    public function getFilters(): JsonResponse
    {
        $services = Services::withoutGlobalScopes()->where('status', 1)->pluck('uuid', 'title');
        $locations = Locations::withoutGlobalScopes()->where('status', 1)->pluck('uuid', 'title');
        $contracts = Contracts::withoutGlobalScopes()->where('status', 1)->pluck('uuid', 'title');
        $filters = ['services' => $services, 'locations' => $locations, 'contracts' => $contracts];

        return response()->json($filters, 200, ['Content-Type', 'application/json'], true);
    }
}
