<?php

namespace Inside\SOFI\Console;

use Illuminate\Console\Command;
use Inside\Host\Bridge\BridgeContent;
use Inside\SOFI\Facades\Tikehau;

class ImportNewsTikehau extends Command
{
    /**
     * @var string
     */
    protected $name = 'sofi:import-news-tikehau';

    /**
     * @var string
     */
    protected $signature = 'sofi:import-news-tikehau';

    /**
     * @var string
     */
    protected $description = 'Import last news tikehau';

    /**
     * @throws \Exception
     */
    public function handle(): void
    {
        $bridge = new BridgeContent();
        $date = Tikehau::getLastTikehauDate('news_tikehau');
        $endpoint = Tikehau::getTikehauUrl(config('tikehau.news.endpoint')) . ($date ? '&created_after=' . $date : '');
        $request = Tikehau::getTikehauResource($endpoint);
        $responseData = json_decode($request);

        if ($responseData->status !== 200 || empty($responseData->data)) {
            return;
        }

        foreach ($responseData->data as $item) {
            $data = $this->buildGoodArrayForInsertContent($item);
            if ($data === null) {
                return;
            }

            $bridge->contentInsert('news_tikehau', $data);
        }
    }

    /**
     * @param mixed $responseData
     * @return array|null
     * @throws \Exception
     */
    public function buildGoodArrayForInsertContent($responseData): ?array
    {
        if (! $responseData->picture->original) {
            return null;
        }

        $imagePath = Tikehau::uploadFileAndImage($responseData->picture->original);
        $contents = Tikehau::manageParagraphForData($responseData);
        $categoryUuuid = config('tikehau.news.categoryUuid');

        $data = [
            'title' => $responseData->title,
            'bundle' => 'news_tikehau',
            'created_at' => date('Y-m-d H:i:s', $responseData->created),
            'image' => $imagePath,
            'news_categories' => $categoryUuuid ? [$categoryUuuid] : [],
            'status' => false,
        ];

        return array_merge($data, $contents);
    }
}
