<?php

namespace Inside\SOFI\Console;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Inside\Host\Bridge\BridgeContent;

class CleanReferencesCommand extends Command
{
    /**
     * @var string
     */
    protected $name = 'sofi:clean-references';

    /*
     * @var string
     */
    protected $signature = 'sofi:clean-references';

    /**
     * @var string
     */
    protected $description = 'Clean sofi filter Services & Locations';

    public function handle(): void
    {
        $contentTypes = ['services', 'locations'];
        $bridge = new BridgeContent();

        foreach ($contentTypes as $contentType) {
            $contents = call_user_func(type_to_class($contentType) . '::all');
            foreach ($contents as $content) {
                $pivots = DB::table('inside_pivots')
                    ->where('related_uuid', $content->uuid)
                    ->get();

                if ($pivots->count() > 0) {
                    continue;
                }

                $this->info(sprintf('Deleting %s %s [uuid: %s]', $contentType, $content->title, $content->uuid));
                $bridge->contentDelete($contentType, $content->uuid);
            }
        }
    }
}
