<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

final class UpdateRhSpacesContentType extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $fields = ["referents", "cta_title", "cta_sub_title", "cta_link", "cta_image"];
        collect($fields)->each(
            fn ($field) => $this->getBridge()?->updateFieldOptions(
                "rh_spaces",
                $field,
                ["required" => false]
            )
        );

        $this->getBridge()?->contentTypeCreateOrUpdateField(
            "rh_spaces",
            "space_links",
            [
                "name" => "space_links",
                "searchable" => false,
                "translatable" => false,
                "default" => false,
                "search_result_field" => false,
                "required" => false,
                "weight" => 3,
                "title" => [
                    "fr" => "Liens utiles",
                ],
                "description" => [],
                "widget" => [
                    "type" => BridgeContentType::SELECT_WIDGET,
                    "weight" => 3,
                ],
                "type" => BridgeContentType::REFERENCE_FIELD,
                "settings" => [
                    "target_type" => ["space_links"],
                    "cardinality" => -1,
                ],
            ]
        );

        $this->finishUp();
    }
}
