<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\GroupsPosts;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Models\Contents\Groups;
use Inside\Notify\Events\CustomNotificationEvent;
use Inside\Notify\Facades\NotificationType as NotificationTypeHelper;
use Inside\Notify\Models\NotificationType;

/**
 * Class FixGroupPostReportNotificationType
 */
class FixGroupPostReportNotificationType extends Migration
{
    /**
     *
     */
    public function up(): void
    {
        Groups::each(function ($group) {
            $notificationType = $this->prepareNotificationTypes(
                [
                    'via'       => 'web',
                    'default'   => false,
                    'event'     => CustomNotificationEvent::class,
                    'model'     => GroupsPosts::class,
                    'action'    => 'report',
                    'type'      => 'global',
                    'condition' => 'groups:' . $group->uuid,
                    'multiple'  => true,
                    'language'  => true,
                    'profile'   => false,
                    'role'      => true,
                ],
                [
                    'title'       => 'notifications.group.report.groups_posts.title',
                    'description' => 'notifications.group.report.groups_posts.description',
                    'icon'        => 'group',
                    'text'        => 'notifications.group.report.groups_posts.text',
                    'fields'      => ['groups', 'authors'],
                    'url'         => 'ROOT_RELATION:groups',
                ]
            );
            NotificationTypeHelper::subscribeRoles(
                $notificationType,
                ['super_administrator', 'group-' . $group->uuid . '-admin'],
                true
            );
        });
    }

    public function down(): void
    {
    }

    protected function prepareNotificationTypes(array $info, array $data): NotificationType
    {
        $notificationType = NotificationType::where($info)->first();
        if ($notificationType instanceof NotificationType) {
            $notificationType->data = $data;
            $notificationType->save();
        } else {
            $info['data']     = $data;
            /** @var NotificationType $notificationType */
            $notificationType = NotificationType::create($info);
        }

        return $notificationType;
    }
}
