<?php

use Inside\Host\Migrations\CreateContentTypes;
use Inside\Notify\Migrations\ReportMigration;
use Inside\Notify\Models\NotificationType;

class CreateReportNotificationComments extends ReportMigration
{
    use CreateContentTypes;

    public function up(): void
    {
        $notificationType = NotificationType::query()
            ->where('event', 'Inside\Notify\Events\CustomNotificationEvent')
            ->where('action', 'report')
            ->where('type', 'global')
            ->where('profile', 1)
            ->first();

        if ($notificationType instanceof NotificationType) {
            $notificationType->profile = 0;
            $notificationType->save();
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
    }
}
