<?php

use Inside\Host\Migrations\CreateContentTypes;
use Inside\Notify\Migrations\ReportMigration;
use Inside\Notify\Models\NotificationType;

class CreationOfReportNotificationsOnDocuments extends ReportMigration
{
    use CreateContentTypes;

    public function up(): void
    {
        $output = $this->getConsole();

        $type = 'documents';

        $this->registerReport(
            ['super_administrator'],
            $type,
            true,
            true,
            'CUSTOM:sofi_ged'
        );

        $output->writeln(' <fg=green>✔</fg=green>');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
    }
}
