<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddFieldsQuickAccessToTools extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $field = [
            'name' => 'quick_access',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'default' => false,
            'weight' => 1,
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'title' => [
                'fr' => 'Accès rapide',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ];

        $bridge->contentTypeCreateOrUpdateField('tools', 'quick_access', $field);
    }

    public function down(): void
    {
    }
}
