<?php

use Inside\Host\Migrations\CreateContentTypes;
use Inside\Notify\Migrations\ReportMigration;
use Inside\Notify\Models\NotificationType;

class CreateReportNotification extends ReportMigration
{
    use CreateContentTypes;

    public function up(): void
    {
        $output = $this->getConsole();

        $output->write("<info>Réinscription des administrateurs aux notifications de report.</info>");

        NotificationType::query()->where('action', 'report')->delete();

        $type = 'comments';

        $this->registerReport(
            ['super_administrator'],
            $type,
            true,
            true,
            'ROOT_RELATION:news,events'
        );

        $output->writeln(' <fg=green>✔</fg=green>');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
    }
}
