<?php

return [
    'schedule' => [
        'ldap' => function ($scheduler) {
            $scheduler->command('inside:user:import ldap --disable-not-imported')->daily()->at('0:00')->after(function () {
                \Illuminate\Support\Facades\Artisan::call('sofi:clean-references');
            });
        },
        'exchange' => function ($scheduler) {
            $scheduler->command('sofi:import-stock-exchange')->daily();
        },
        'tikehau-news' => function ($scheduler) {
            $scheduler->command('sofi:import-news-tikehau')->daily()->at('0:00');
        },
        'tikehau-event' => function ($scheduler) {
            $scheduler->command('sofi:import-events-tikehau')->daily()->at('0:00');
        },
        'export-jobs' => function ($scheduler) {
            $scheduler->command('sofi:export-jobs')->daily()->at('2:00');
        },
    ],
];
