<?php

return [
    'manual_notifications' => [
        'enabled' => true,
        'enhanced_notifications' => false,
        'enhanced_notifications_types_and_fields' => [
            'news' => [
                'fields' => [
                    'image',
                    'chapo',
                ]
            ],
            'events' => [
                'fields' => [
                    'image',
                    'chapo',
                ]
            ],
            'external_notifications' => [
                'fields' => [
                    'image',
                ],
            ],
        ],
        'enabled_types' => [
            'news',
        ],
    ],
    'build_url_callbacks' => [
        'sofi_ged' => function ($model) {
            $contentType = class_to_type($model);
            $contentUuid = $model->uuid;
            return 'edit/' . $contentType . '/' . $contentUuid;
        }
    ]
];
