<?php

use Inside\Content\Facades\ContentHelper;
use Illuminate\Support\Arr;

return [
    'inside_external_api_enabled' => env('INSIDE_EXTERNAL_API_ENABLED', true),
    'inside_external_api_bypass_auth_external' => env('INSIDE_EXTERNAL_API_AUTH_BYPASS', true),
    'inside_external_api_pagination_limit' => 10,
    'inside_external_api_paginate_result' => false,
    'inside_external_api_fields' => [
        'jobs' => [
            'title',
            'email',
            'created_at',
            'content',
            'main_location' => ['title'],
            'locations' => ['title'],
            'services' => ['title'],
            'contracts' => ['title'],
        ],
    ],
    'inside_external_api_fields_content_remove' => [
        'section_type',
        'uuid',
        'created_at',
        'updated_at',
        'reactions',
        'file',
        'title',
        'description',
    ],
    'inside_external_api_filters' => function ($query, $request) {
        $filters = ContentHelper::extractFiltersInputFromRequest($request);
        if (! empty($filters)) {
            foreach ($filters as $key => $filter) {
                $query->whereHas($key, fn ($q) => $q->where('uuid', $filter));
            }
        }
        $query->where('status', 1)->where('share_sofidy', 1);
        return $query;
    },
    'inside_external_api_transform' => function ($result) {
        return collect($result)->map(function ($data) {
            $data['content'] = collect($data['content'])->map(
                fn ($content) => Arr::except(
                    $content,
                    config('external_api.inside_external_api_fields_content_remove')
                )
            )->filter()->toArray();
            // this is a bug, but should be kept before we call the client, see with Elyes why we need to do that #temporary
            $data['content'] = Arr::last($data['content']);

            return $data;
        })->toArray();
    },
];
