<?php

use Illuminate\Support\Facades\Route;
use Inside\Content\Http\Controllers\External\Index as ExternalIndex;

Route::group(
    [
        'namespace' => 'Inside\SOFI\Http\Controllers',
        'prefix'     => 'api/v1',
        'middleware' => 'auth.external:sofidy',
    ],
    function ($router) {
        $router->get('external/job/{uuid}', 'JobOffersController@getJob');
        $router->get('external/filters', 'JobOffersController@getFilters');
    }
);

Route::group(
    [
        'prefix' => 'api/v1',
        'middleware' => ['auth.external:sofidy'],
    ],
    function ($router) {
        $router->get('external/{type:'.get_authorized_external_api_content_types().'}', ExternalIndex::class);
    }
);
