<?php

namespace Inside\SOFI\Services;

use Illuminate\Http\Request;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Support\Arr;
use Illuminate\Support\Collection;
use Inside\Content\Facades\ContentHelper;
use Inside\Content\Transformers\ContentTransformer;
use Inside\Database\Eloquent\Builder;

/**
 * @class JobOffersService
 *
 * @package Inside\SOFI\Services
 */
class JobOffersService
{
    public function removeUselessContents(array $data): array
    {
        foreach ($data['content'] as $content) {
            if (in_array('text', $content)) {
                $result = Arr::except($content, ['section_type', 'uuid', 'created_at', 'updated_at', 'reactions', 'file', 'title', 'description']);
                $data['content'] = $result;
            }
        }

        return $data;
    }
}
