<?php

namespace Inside\SOFI\Console;

use Illuminate\Console\Command;
use Inside\Settings\Models\Setting;
use Inside\SOFI\Facades\Alphavantage;

class ImportStockExchange extends Command
{
    /**
     * @var string
     */
    protected $name = 'sofi:import-stock-exchange';

    /**
     * @var string
     */
    protected $signature = 'sofi:import-stock-exchange';

    /**
     * @var string
     */
    protected $description = 'Import flux json stock exchange';

    public function handle(): void
    {
        $stocks = [
            'SELECTIRENTE' => 'SELER.PA',
            'TIKEHAU CAPITAL' => 'TKO.PA',
        ];

        $value = collect($stocks)
            ->map(function (string $symbol, string $name) {
                $globalQuote = Alphavantage::getGlobalQuote($symbol);

                if (empty($globalQuote)) {
                    return null;
                }

                return [
                    'name' => $name,
                    'currency' => 'eur',
                    'price' => number_format($globalQuote['price'], 2),
                    'percentage' => number_format($globalQuote['change percent'], 2),
                ];
            })
            ->filter()
            ->values()
            ->all();

        $settings = [
            'group' => 'sofi',
            'key' => 'stock_exchange',
            'value' => $value
        ];

        Setting::updateOrCreate(
            [
                'group' => $settings['group'],
                'key'   => $settings['key'],
            ],
            [
                'value' => json_encode($settings),
            ]
        );
    }
}
