<?php

namespace Inside\SOFI\Console;

use Illuminate\Console\Command;
use Inside\Host\Bridge\BridgeContent;
use Inside\SOFI\Facades\Tikehau;

class ImportEventsTikehau extends Command
{
    /**
     * @var string
     */
    protected $name = 'sofi:import-events-tikehau';

    /**
     * @var string
     */
    protected $signature = 'sofi:import-events-tikehau';

    /**
     * @var string
     */
    protected $description = 'Import last events tikehau';

    public function handle(): void
    {
        $bridge = new BridgeContent();
        $date = Tikehau::getLastTikehauDate('events');
        $endpoint = Tikehau::getTikehauUrl(config('tikehau.events.endpoint')).($date ? '&created_after='.$date : '');
        $request = Tikehau::getTikehauResource($endpoint);
        $responseData = json_decode($request);

        if ($responseData->status !== 200 || empty($responseData->data)) {
            return;
        }

        foreach ($responseData->data as $item) {
            $data = $this->buildGoodArrayForInsertContent($item);

            if ($data === null) {
                return;
            }

            $bridge->contentInsert('events', $data);
        }
    }

    /**
     * @param mixed $responseData
     * @return array|null
     * @throws \Exception
     */
    public function buildGoodArrayForInsertContent($responseData): ?array
    {
        if (! $responseData->picture->original) {
            return null;
        }

        $imagePath = Tikehau::uploadFileAndImage($responseData->picture->original);
        $contents = Tikehau::manageParagraphForData($responseData);
        $categoryUuid = config('tikehau.events.categoryUuid');

        $data = [
            'title' => $responseData->title,
            'bundle' => 'events',
            'created_at' => date('Y-m-d H:i:s', $responseData->created),
            'status' => false,
            'image' => $imagePath,
            'date' => date('Y-m-d H:i:s', $responseData->start),
            'place' => $responseData->address,
            'end_date' => $responseData->end ? date('Y-m-d H:i:s', $responseData->end) : null,
            'events_categories' => $categoryUuid ? [$categoryUuid] : [],
        ];

        return array_merge($data, $contents);
    }
}
