<?php

return [
    '_meta' => [
        'type' => 'newsletters',
        'fieldsPrefix' => ''
    ],
    'logo' => [
        'showLogo'  => true,
        'logoUrl'   => 'vendor/maecia/sofi-back/resources/assets/img/newsletter/logo.png',
        'logoWidth' => 200
    ],
    'banner'       => [
        'backgroundColor' => '#032c49'
    ],
    'introduction' => [
        'introductionFieldName' => 'newsletter_introduction',
        'textColor' => '#2C3E50'
    ],
    'sections'     => [
        'news'       => [
            'sectionTitleStrKey' => 'newsletter.news_title',
            'types' => ['news', 'news_tikehau'],
            'dateFormat' => '%d/%m/%Y',
            'showCategoryTitle' => true,
            'defaultCategoryColor' => '#032c49',
            'link' => [
                'sectionLinkUrl'  => 'actualites',
                'sectionTextColor' => '#2C3E50',
            ],
        ],
        'events'     => [
            'sectionTitleStrKey' => 'newsletter.events_title',
            'types' => ['events'],
            'sorts' => ['date:desc'],
            'dateFormat' => '%d/%m/%Y',
            'link' => [
                'sectionLinkUrl'   => 'evenements',
                'sectionTextColor' => '#2C3E50',
            ],
        ],
        'documents'  => [
            'sectionTitleStrKey' => 'newsletter.documents_title',
            'types'           => ['documents'],
            'sorts' => ['created_at:desc'],
            'imageStyle' => 'medium',
            'dateFormat' => '%d/%m/%Y',
            'link'            => [
                'sectionLinkStrKey' => 'newsletter.see_all_documents',
                'sectionLinkUrl' => 'bibliotheque',
                'sectionTextColor' => '#2C3E50'
            ],
        ],
        'new_members' => [
            'sectionTitleStrKey' => 'newsletter.new_members_title',
            'introductionLength' => 50,
            'introductionFieldName' => 'function',
            'types'           => ['new_comer'],
        ],
    ],
    'socials'      => [
        'backgroundColor' => '#002d47',
        'links' => [
            'youtube' => [
                'url' => 'https://www.youtube.com/channel/UC--Cqe-otxhOtIhMyXprkaQ',
            ],
            'twitter' => [
                'url' => 'https://twitter.com/sofidy',
            ],
            'linkedin' => [
                'url' => 'https://www.linkedin.com/company/groupe-sofidy',
            ],
            'instagram' => [
                'url' => 'https://www.instagram.com/groupesofidy',
            ]
        ],
    ],
    'footer'       => [
        'backgroundColor' => '#ffffff',
        'unsubscribeTextColor' => '#818181',
        'unsubscribeTextStrKey' => 'newsletter.unsubscribe.warning'
    ],
];
