<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class ChangeWidgetRhCategoriesFromRhPages extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'rh_pages',
            'spaces_categories',
            [
                'name' => 'spaces_categories',
                'required' => true,
                'title' => [
                    'fr' => 'Catégorie d\'espaces'
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 2,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['rh_categories'],
                    'cardinality' => -1,
                ],
            ]
        );
    }
}
