<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddLocationsToJobs extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'jobs',
            'locations',
            [
                'name' => 'locations',
                'weight' => 4,
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'title' => [
                    'fr' => 'Localisation',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'weight' => 4,
                    'settings' => [],
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['locations'],
                    'cardinality' => 1,
                ],
            ]
        );
    }
}
