<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Facades\Schema;

class AddFetchedContentsSectionToTypesThatHasContentField extends Migration
{
    public function up(): void
    {
        $contentTypesWithContentField = collect(Schema::getContentTypes())
            ->filter(fn ($type) => Schema::hasField($type, 'content'))
            ->filter(fn ($type) => !blank(array_intersect(['updated_document_cards', 'document_cards', 'user_cards'], Schema::getFieldOptions($type, 'content')['target'])));

        $contentSectionTargetTypes = Schema::getFieldOptions('jobs', 'content')['target'];
        $sectionsToRemove = ["user_cards", "updated_document_cards", "document_cards"];

        $contentSectionTargetTypes = array_diff($contentSectionTargetTypes, $sectionsToRemove);
        $contentSectionTargetTypes[] = 'fetched_contents';

        $bridge = new BridgeContentType();

        collect($contentTypesWithContentField)->each(function ($contentType) use ($bridge, $contentSectionTargetTypes) {
            $bridge->contentTypeCreateOrUpdateField(
                $contentType,
                'content',
                [
                    'name' => 'content',
                    'type' => BridgeContentType::SECTION_FIELD,
                    'settings' => [
                        'target_type' => $contentSectionTargetTypes,
                        'cardinality' => -1,
                    ],
                ],
                -1
            );
        });
    }
}
