<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class SetRhSpacesFieldsAsNotRequired extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        collect(['cta_title', 'cta_sub_title', 'cta_image'])
            ->each(fn ($field) => $bridge->updateFieldOptions('rh_spaces', $field, ['required' => false ]));
    }
}
