<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddBoolFieldsToRhSpaces extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        collect([
            [
                'name' => 'show_job_offers',
                'title' => 'Afficher les offres d’emploi',
                'weight' => 3,
            ],
            [
                'name' => 'show_call_to_action',
                'title' => 'Afficher le Call To Action',
                'weight' => 4,
            ],
        ])->each(fn ($field) => $bridge->contentTypeCreateOrUpdateField(
            'rh_spaces',
            $field['name'],
            [
                'name' => $field['name'],
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => $field['weight'],
                'title' => [
                    'fr' => $field['title']
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                    'weight' => $field['weight'],
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
                'default' => true,
            ],
        ));
    }
}
