<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

final class AddToolsIconField extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->contentTypeCreateOrUpdateField(
            type: 'tools',
            fieldName: 'icon',
            options: [
                'name' => 'icon',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'title' => [
                    'fr' => 'Icone',
                ],
                'description' => [
                    'fr' => 'Définissez une icone pour votre outil, si une image est remplie cette icone ne remontera pas',
                ],
                'widget' => [
                    'type' => BridgeContentType::INSIDE_ICON_PICKER_WIDGET,
                    'settings' => [],
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            weight: 3
        );
        $this->finishUp();
    }
}
