<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class FixReferenceCseFolders extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('node', 'cse_documents', 'folders');
        $bridge->contentTypeCreateOrUpdateField(
            'cse_documents',
            'cse_folders',
            [
                'name' => 'cse_folders',
                'searchable' => false,
                'translatable' => false,
                'default' => false,
                'search_result_field' => false,
                'required' => true,
                'title' => [
                    'fr' => 'Dossier parent',
                ],
                'description' => [],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'group' => 'group_advanced_options',
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['cse_folders'],
                    'cardinality' => -1,
                ],
            ],
        );
    }

    public function down(): void
    {
    }
}
