<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class RefactoJobsContentType extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'jobs',
            'main_location',
            [
                'name' => 'main_location',
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => false,
                'required' => true,
                'title' => [
                    'fr' => 'Localisation principale',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['locations'],
                    'cardinality' => 1,
                ],
            ]
        );

        $bridge->contentTypeCreateOrUpdateField(
            'jobs',
            'share_sofidy',
            [
                'name' => 'share_sofidy',
                'searchable' => false,
                'translatable' => false,
                'default' => true,
                'search_result_field' => false,
                'required' => false,
                'title' => [
                    'fr' => 'L\'offre d\'emploie remonte sur sofidy ?'
                ],
                'description' => [
                    'fr' => ''
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                    'group' => 'group_advanced_options',
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
            ]
        );
    }

    public function down(): void
    {
    }
}
