<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class CreationOfTheTypeOfContentEntities extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('entities');
        $this->finishUp();


        $bridge = new BridgeContentType();
        $bridge->contentTypeCreateOrUpdateField(
            'users',
            'entities',
            [
                'name' => 'entities',
                'type' => BridgeContentType::REFERENCE_FIELD,
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 3,
                'title' => [
                    'fr' => 'Entité',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                ],
                'settings' => [
                    'target_type' => 'entities',
                    'cardinality' => 1,
                ],
            ],
            3
        );
    }

    public function down(): void
    {
    }
}
