<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddedWeightFieldOnTheOrganizationalChartAndRhPages extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'rh_pages',
            'weight',
            [
                'name' => 'weight',
                'type' => BridgeContentType::INTEGER_FIELD,
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'weight' => 3,
                'title' => [
                    'fr' => 'Poids',
                ],
                'widget' => [
                    'type' => BridgeContentType::NUMBER_WIDGET,
                    'settings' => [],
                ],
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            3
        );

        $bridge->contentTypeCreateOrUpdateField(
            'organizational_chart',
            'weight',
            [
                'name' => 'weight',
                'type' => BridgeContentType::INTEGER_FIELD,
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 4,
                'title' => [
                    'fr' => 'Poids',
                ],
                'widget' => [
                    'type' => BridgeContentType::NUMBER_WIDGET,
                    'settings' => [],
                ],
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            4
        );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
    }
}
